import React from 'react';
import { TicketForm } from './components/TicketForm';

function App() {
  return (
    <div className="min-h-screen bg-gray-50 bg-[url('https://www.transparenttextures.com/patterns/cubes.png')] flex flex-col items-center justify-center p-4 md:p-6">
      
      {/* Header / Brand Area */}
      <div className="mb-8 text-center">
        <h1 className="text-4xl font-black text-transparent bg-clip-text bg-gradient-to-r from-indigo-600 to-purple-600 mb-2 tracking-tight">
          شایان پیکس
        </h1>
        <p className="text-gray-500 font-medium">سامانه ارتباط با مشتریان</p>
      </div>

      {/* Main Content */}
      <TicketForm />

      {/* Footer */}
      <footer className="mt-8 text-center text-gray-400 text-sm">
        <p>© 2024 ShayanPix. تمامی حقوق محفوظ است.</p>
      </footer>
    </div>
  );
}

export default App;